/*
 * Decompiled with CFR 0.152.
 */
package com.tino1b2be.dtmfdecoder;

import com.tino1b2be.audio.AudioFile;
import com.tino1b2be.audio.AudioFileException;
import com.tino1b2be.audio.WavFile;
import com.tino1b2be.audio.WavFileException;
import com.tino1b2be.cmdprograms.AudioTestResult;
import com.tino1b2be.cmdprograms.TestResult;
import com.tino1b2be.dtmfdecoder.DTMFDecoderException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import javax.sound.sampled.UnsupportedAudioFileException;

public class FileUtil {
    public static ArrayList<String> loadFile(String filename) throws IOException {
        String line;
        FileInputStream fstream = new FileInputStream(filename);
        BufferedReader br = new BufferedReader(new InputStreamReader(fstream));
        ArrayList<String> data = new ArrayList<String>();
        int count = 0;
        while ((line = br.readLine()) != null) {
            data.add(line);
            ++count;
        }
        br.close();
        if (count == 0) {
            return null;
        }
        return data;
    }

    public static <T> void writeToFile(ArrayList<T> dataOut, String filename) throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter(filename));
        if (dataOut == null) {
            pw.print("");
        } else {
            for (int i = 0; i < dataOut.size(); ++i) {
                pw.println(dataOut.get(i).toString());
            }
        }
        pw.close();
    }

    public static <T> void writeToFile(ArrayBlockingQueue<T> dataOut, String filename) throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter(filename));
        if (dataOut == null) {
            pw.print("");
        } else {
            for (T data : dataOut) {
                if (data.getClass() == TestResult.class && ((TestResult)data).isSuccess()) {
                    ++TestResult.totalSuccess;
                }
                pw.println(data);
            }
        }
        pw.close();
    }

    public static void writeToFile(TestResult[] dataOut, String filename) throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter(filename));
        if (dataOut == null) {
            pw.print("");
        } else {
            for (TestResult data : dataOut) {
                if (data.isSuccess()) {
                    ++TestResult.totalSuccess;
                }
                pw.println(data);
            }
        }
        pw.close();
    }

    public static ArrayList<File> getDirs(String parent) throws DTMFDecoderException, FileNotFoundException {
        if (!new File(parent).exists()) {
            throw new FileNotFoundException("The given file path does not exist.");
        }
        if (!new File(parent).isDirectory()) {
            throw new DTMFDecoderException("The given filepath does not represent a directory.");
        }
        ArrayList<File> files = new ArrayList<File>();
        File dir = new File(parent);
        File[] directoryListing = dir.listFiles();
        if (directoryListing != null) {
            for (File child : directoryListing) {
                if (!child.isDirectory()) continue;
                files.add(child);
            }
        } else {
            throw new DTMFDecoderException("The given directpry is empty.");
        }
        return files;
    }

    public static ArrayList<File> getFiles(File directory, String extension) throws IOException, DTMFDecoderException {
        return FileUtil.getFiles(directory.getAbsolutePath(), extension);
    }

    public static ArrayList<File> getFiles(String directory, String extension) {
        ArrayList<File> files = new ArrayList<File>();
        FileUtil.recursiveFileSearch(directory, files, extension);
        return files;
    }

    private static void recursiveFileSearch(String path, ArrayList<File> files, String extension) {
        File dir = new File(path);
        File[] directoryListing = dir.listFiles();
        if (directoryListing != null) {
            for (File child : directoryListing) {
                if (child.isDirectory()) {
                    FileUtil.recursiveFileSearch(child.getPath(), files, extension);
                }
                if (!child.getAbsolutePath().endsWith(extension) && !child.getAbsolutePath().endsWith(extension)) continue;
                files.add(child);
            }
        }
    }

    public static void writeToFile(AudioTestResult[] dataOut, String filename) throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter(filename));
        if (dataOut == null) {
            pw.print("");
        } else {
            for (AudioTestResult data : dataOut) {
                pw.println(data);
            }
        }
        pw.close();
    }

    public static void writeToFileSuccessOnly(AudioTestResult[] dataOut, String filename) throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter(filename));
        if (dataOut == null) {
            pw.print("");
        } else {
            for (AudioTestResult data : dataOut) {
                if (!data.sequenceFound()) continue;
                pw.println(data);
            }
        }
        pw.close();
    }

    private static WavFile readWavFileBuffer(String filename) throws IOException, WavFileException {
        WavFile f = new WavFile(WavFile.openWavFile(new File(filename)));
        return f;
    }

    private static WavFile readWavFileBuffer(File file) throws IOException, WavFileException {
        WavFile f = FileUtil.readWavFileBuffer(file.getPath());
        return f;
    }

    public static AudioFile readAudioFile(String filename) throws AudioFileException, IOException {
        AudioFile f = FileUtil.readAudioFile(new File(filename));
        return f;
    }

    public static AudioFile readAudioFile(File file) throws AudioFileException, IOException {
        if (file.getName().toLowerCase().endsWith(".wav")) {
            WavFile f;
            try {
                f = FileUtil.readWavFileBuffer(file);
            }
            catch (WavFileException e) {
                throw new AudioFileException(e.getMessage());
            }
            return f;
        }
        throw new AudioFileException("File type not supported.");
    }

    public static AudioFile readAudioFile(String filename, AudioFile.AudioType type) throws UnsupportedAudioFileException, IOException, WavFileException, AudioFileException {
        if (type.equals((Object)AudioFile.AudioType.WAV)) {
            return FileUtil.readWavFileBuffer(filename);
        }
        throw new AudioFileException("File type not supported.");
    }

    public static void writeWavFile(File outFile, double[] samples, double outFs) throws IOException, WavFileException {
        int fs = (int)outFs;
        if (!outFile.toString().endsWith(".wav")) {
            outFile = new File(outFile.getAbsolutePath() + ".wav");
        }
        WavFile wavFile = new WavFile(outFile, 1, samples.length, 16, fs);
        wavFile.writeFrames(samples, samples.length);
        wavFile.close();
    }

    public static void writeToFile(double[] dataOut, String filename) throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter(filename));
        if (dataOut == null) {
            pw.print("");
        } else {
            for (int i = 0; i < dataOut.length; ++i) {
                pw.print(dataOut[i] + ", ");
            }
        }
        pw.close();
    }
}

